/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Nicole 07/05/2007 v8.0655 REMOVE_SPACE_FOR_LOCATION_STRING					*
 *	Hong 06/17/09 QA80-13280 EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS			*
 *	Hong 07/21/09 QA80-13280-P4 WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS			*
 *	Hong 09/10/09 QA80-13280-P10 FIX_PRINT_MARGIN_BOTTOM_TOP_FAIL_UPDATE_WHEN_SWITCH_UNIT_IN_EXP_MULTIPAGE_PDF
 *	Hong 09/10/09 QA80-13280-P5 FIX_EXPPDFW_PRINT_MARGIN_THEME_VALUE_FAIL_CORRECTLY_APPLIED
 *	Hong 11/02/09 QA80-14562 EXP_MULTI_PAGE_PDF_SUPPORT_ORIENTATION_OPTION		*
 *	Folger 11/03/09 CLEAN_WKS_PRINT_OPTION_SETTINGS_ACCESS						*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.

#include <GetNBox.h>   
#include "commonDlgs.h"

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

bool unit_convertion(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	/// Hong 09/10/09 QA80-13280-P5 FIX_EXPPDFW_PRINT_MARGIN_THEME_VALUE_FAIL_CORRECTLY_APPLIED
	// indeed, GETNEVENT_ON_INIT should be handled here too, but there is already old mechanism to handle it below by SetAttribe, so ignore here
	if ( GETNEVENT_ON_THEME == dwCntrl )
		return true;
	/// end FIX_EXPPDFW_PRINT_MARGIN_THEME_VALUE_FAIL_CORRECTLY_APPLIED
	int nInit = 0;
	double dFactor;
	//-------- CPY 5/22/07 USING_SAME_FUNCTION_FOR_DLG_AND_INIT
	//myTree.GetAttribute("Init", nInit);
	//if (nInit == 0)
	//{
	//	myTree.SetAttribute("Init", 1);
	if(trNode.GetAttribute(STR_PRINT_UNITS_INIT_ATTRIB, nInit) && nInit == 0)
	{
		trNode.RemoveAttribute(STR_PRINT_UNITS_INIT_ATTRIB);
		return true;			///Folger 05/28/07
	//--------
		dFactor = MARGIN_MM_FACTOR;
	}
	else if (trNode.Use == PRINT_UNITS_MM)
	{
		dFactor = (double)(MARGIN_MM_FACTOR) / (double)(MARGIN_INCH_FACTOR);
	}
	else if (trNode.Use == PRINT_UNITS_INCH)
	{
		dFactor = (double)(MARGIN_INCH_FACTOR) / (double)(MARGIN_MM_FACTOR);
	}
	/// Hong 09/10/09 QA80-13280-P10 FIX_PRINT_MARGIN_BOTTOM_TOP_FAIL_UPDATE_WHEN_SWITCH_UNIT_IN_EXP_MULTIPAGE_PDF
	//TreeNode Left = tree_get_node_by_tagname(myTree, "Left", true);
	//TreeNode Right = tree_get_node_by_tagname(myTree, "Right", true);
	//TreeNode Top = tree_get_node_by_tagname(myTree, "Top", true);
	//TreeNode Bottom = tree_get_node_by_tagname(myTree, "Bottom", true);
	TreeNode Left = tree_get_node_by_tagname(trNode, "Left", true);
	TreeNode Right = tree_get_node_by_tagname(trNode, "Right", true);
	TreeNode Top = tree_get_node_by_tagname(trNode, "Top", true);
	TreeNode Bottom = tree_get_node_by_tagname(trNode, "Bottom", true);
	/// end FIX_PRINT_MARGIN_BOTTOM_TOP_FAIL_UPDATE_WHEN_SWITCH_UNIT_IN_EXP_MULTIPAGE_PDF
	Left.dVal /= dFactor;
	Right.dVal /= dFactor;
	Top.dVal /= dFactor;
	Bottom.dVal /= dFactor;
	
	return true;
}
///End PRINT_OPTIONS_FOR_WKS_PRINT

bool print_option_construct_tree(TreeNode &tr, const DWORD &dwSet, const TreeNode & trMargin)
{
	/// Hong 06/17/09 QA80-13280 EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS
#ifdef		SUPPORT_EXPORT_MULTI_PAGES_PDF
	construct_print_option_tree(tr, dwSet, trMargin.Left.dVal, trMargin.Right.dVal, trMargin.Top.dVal, trMargin.Bottom.dVal);
	return true;
#else		//SUPPORT_EXPORT_MULTI_PAGES_PDF
	/// end EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS
	GETN_USE(tr)
//		tr.SetAttribute(STR_PRINT_UNITS_INIT_ATTRIB, 0);
   		GETN_BEGIN_BRANCH(Check, _L("Worksheet Print Options")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
       		GETN_CHECK(Chk_Horz_Grids, _L("Horizontal Grids"), dwSet & GPC_HORZ_GRIDS)
       		GETN_CHECK(Chk_Vert_Grids, _L("Vertical Grids"), dwSet & GPC_VERT_GRIDS)
       		GETN_CHECK(Chk_Row_Header, _L("Row Header"), dwSet & GPC_ROW_HEADER) 
       		GETN_CHECK(Chk_Col_Header, _L("Column Header"), dwSet & GPC_COL_HEADER)
       		GETN_CHECK(Chk_Page_Header, _L("Page Header"), dwSet & GPC_PAGE_HEADER)
       		GETN_CHECK(Chk_Page_Footer, _L("Page Footer"), dwSet & GPC_PAGE_FOOTER)
       		GETN_CHECK(Chk_BkColor, _L("Background Color"), dwSet & GPC_BACKGROUND)
       		GETN_CHECK(Chk_Frame, _L("Frame"), dwSet & GPC_FRAME)
       		GETN_CHECK(Chk_EmptyCols, _L("Empty Cols"), dwSet & GPC_EMPTY_COLS)
       		GETN_CHECK(Chk_EmptyRows, _L("Empty Rows"), dwSet & GPC_EMPTY_ROWS)
   		GETN_END_BRANCH(Check)
   		GETN_BEGIN_BRANCH(Margin, _L("Margin")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
   		/// Nicole 07/05/2007 v8.0655 REMOVE_SPACE_FOR_LOCATION_STRING
	   	//										GETN_COMBO_BRANCH(0, _L("mm | inch")) 
	   											GETN_COMBO_BRANCH(0, _L("mm|inch")) 
		/// END REMOVE_SPACE_FOR_LOCATION_STRING
	   											GETN_OPTION_EVENT_EX(unit_convertion)
	   											tr.Margin.SetAttribute(STR_PRINT_UNITS_INIT_ATTRIB, 0);	///Folger 05/28/07
	   		GETN_NUM(Left, _L("Left"), trMargin.Left.dVal / MARGIN_MM_FACTOR)
	   		GETN_NUM(Right, _L("Right"), trMargin.Right.dVal / MARGIN_MM_FACTOR)
	   		GETN_NUM(Top, _L("Top"), trMargin.Top.dVal / MARGIN_MM_FACTOR)
	   		GETN_NUM(Bottom, _L("Bottom"), trMargin.Bottom.dVal / MARGIN_MM_FACTOR)
   		GETN_END_BRANCH(Margin)
   	return true;
#endif		//SUPPORT_EXPORT_MULTI_PAGES_PDF /// Hong 06/17/09 QA80-13280 EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS
}

/// Hong 06/17/09 QA80-13280 EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS
#ifdef		SUPPORT_EXPORT_MULTI_PAGES_PDF

/// Hong 07/21/09 QA80-13280-P4 WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
bool apply_wks_print_options(Worksheet& wks, TreeNode& trGetNPrintOpts)
{
	Tree 		trPrintOptions;
	if ( !wks.GetPrintOptions(trPrintOptions) )
		return false;
	
	DWORD 		dwSet = trPrintOptions.Root.Print.Cntrl.nVal;
	TreeNode 	trMargin = trPrintOptions.Root.Print.Margin;
	Tree		tr;
	print_option_construct_tree(tr, dwSet, trMargin);
	tree_copy_values(tr, trGetNPrintOpts, 0);
	/// Hong 11/02/09 QA80-14562 EXP_MULTI_PAGE_PDF_SUPPORT_ORIENTATION_OPTION
	if ( trGetNPrintOpts.Orientation )
	{
		trGetNPrintOpts.Orientation.nVal = (GPC_PAGE_LANDSCAPE & dwSet) ? 1 : 0; // "Portrait|Landscape"
	}
	/// end EXP_MULTI_PAGE_PDF_SUPPORT_ORIENTATION_OPTION
	return true;
}
/// end WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS

// Hong, this function assume "Worksheet Print Options" to be first subNode which is used in GraphicalExport.c
void construct_print_option_tree(TreeNode &tr, DWORD dwSet, double dLeft, double dRight, double dTop, double dBottom, bool bHideForExport = false)
{
	ASSERT(tr);
	GETN_USE(tr)
//		tr.SetAttribute(STR_PRINT_UNITS_INIT_ATTRIB, 0);
   		GETN_BEGIN_BRANCH(Check, _L("Worksheet Print Options")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
       		GETN_CHECK(Chk_Horz_Grids, _L("Horizontal Grids"), dwSet & GPC_HORZ_GRIDS)
       		GETN_CHECK(Chk_Vert_Grids, _L("Vertical Grids"), dwSet & GPC_VERT_GRIDS)
       		GETN_CHECK(Chk_Row_Header, _L("Row Header"), dwSet & GPC_ROW_HEADER) 
       		GETN_CHECK(Chk_Col_Header, _L("Column Header"), dwSet & GPC_COL_HEADER)
       		GETN_CHECK(Chk_Page_Header, _L("Page Header"), dwSet & GPC_PAGE_HEADER)
       		GETN_CHECK(Chk_Page_Footer, _L("Page Footer"), dwSet & GPC_PAGE_FOOTER)
       		GETN_CHECK(Chk_BkColor, _L("Background Color"), dwSet & GPC_BACKGROUND)
       		GETN_CHECK(Chk_Frame, _L("Frame"), dwSet & GPC_FRAME)
       		GETN_CHECK(Chk_EmptyCols, _L("Empty Cols"), dwSet & GPC_EMPTY_COLS)
       		GETN_CHECK(Chk_EmptyRows, _L("Empty Rows"), dwSet & GPC_EMPTY_ROWS)
   		GETN_END_BRANCH(Check)
   		GETN_BEGIN_BRANCH(Margin, _L("Margin")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
   		/// Nicole 07/05/2007 v8.0655 REMOVE_SPACE_FOR_LOCATION_STRING
	   	//										GETN_COMBO_BRANCH(0, _L("mm | inch")) 
	   											GETN_COMBO_BRANCH(0, _L("mm|inch")) 
		/// END REMOVE_SPACE_FOR_LOCATION_STRING
	   											GETN_OPTION_EVENT_EX(unit_convertion)
	   											tr.Margin.SetAttribute(STR_PRINT_UNITS_INIT_ATTRIB, 0);	///Folger 05/28/07
	   		GETN_NUM(Left, _L("Left"), dLeft / MARGIN_MM_FACTOR)
	   		GETN_NUM(Right, _L("Right"), dRight / MARGIN_MM_FACTOR)
	   		GETN_NUM(Top, _L("Top"), dTop / MARGIN_MM_FACTOR)
	   		GETN_NUM(Bottom, _L("Bottom"), dBottom / MARGIN_MM_FACTOR)
   		GETN_END_BRANCH(Margin)
   		
   		if ( bHideForExport )
   		{
   			tr.Check.Chk_Page_Header.Show = FALSE;
   			tr.Check.Chk_Page_Footer.Show = FALSE;
   			tr.Margin.Show = FALSE;
   		}
}

static void _cvt_getn_print_options_to_wks_print_options(TreeNode& trWksPrintOpts, const TreeNode& trGetNPrintOpts)
{
	///------ Folger 11/03/09 CLEAN_WKS_PRINT_OPTION_SETTINGS_ACCESS
	//DWORD 		dwSet =	(trGetNPrintOpts.Check.Chk_Horz_Grids.nVal ? GPC_HORZ_GRIDS : 0) |
						//(trGetNPrintOpts.Check.Chk_Vert_Grids.nVal ? GPC_VERT_GRIDS : 0) |
						//(trGetNPrintOpts.Check.Chk_Row_Header.nVal ? GPC_ROW_HEADER : 0) |
						//(trGetNPrintOpts.Check.Chk_Col_Header.nVal ? GPC_COL_HEADER : 0) |
						//(trGetNPrintOpts.Check.Chk_Page_Header.nVal ? GPC_PAGE_HEADER : 0) |
						//(trGetNPrintOpts.Check.Chk_Page_Footer.nVal ? GPC_PAGE_FOOTER : 0) |
						//(trGetNPrintOpts.Check.Chk_BkColor.nVal ? GPC_BACKGROUND : 0) |
						//(trGetNPrintOpts.Check.Chk_Frame.nVal ? GPC_FRAME : 0) |
						//(trGetNPrintOpts.Check.Chk_EmptyCols.nVal ? GPC_EMPTY_COLS : 0) |
						//(trGetNPrintOpts.Check.Chk_EmptyRows.nVal ? GPC_EMPTY_ROWS : 0);
	DWORD		dwSet = trWksPrintOpts.Root.Print.Cntrl.nVal;
	O_SET_BIT(dwSet, GPC_HORZ_GRIDS, trGetNPrintOpts.Check.Chk_Horz_Grids.nVal);
	O_SET_BIT(dwSet, GPC_VERT_GRIDS, trGetNPrintOpts.Check.Chk_Vert_Grids.nVal);
	O_SET_BIT(dwSet, GPC_ROW_HEADER, trGetNPrintOpts.Check.Chk_Row_Header.nVal);
	O_SET_BIT(dwSet, GPC_COL_HEADER, trGetNPrintOpts.Check.Chk_Col_Header.nVal);
	O_SET_BIT(dwSet, GPC_PAGE_HEADER, trGetNPrintOpts.Check.Chk_Page_Header.nVal);
	O_SET_BIT(dwSet, GPC_PAGE_FOOTER, trGetNPrintOpts.Check.Chk_Page_Footer.nVal);
	O_SET_BIT(dwSet, GPC_BACKGROUND, trGetNPrintOpts.Check.Chk_BkColor.nVal);
	O_SET_BIT(dwSet, GPC_FRAME, trGetNPrintOpts.Check.Chk_Frame.nVal);
	O_SET_BIT(dwSet, GPC_EMPTY_COLS, trGetNPrintOpts.Check.Chk_EmptyCols.nVal);
	O_SET_BIT(dwSet, GPC_EMPTY_ROWS, trGetNPrintOpts.Check.Chk_EmptyRows.nVal);
	///------ End CLEAN_WKS_PRINT_OPTION_SETTINGS_ACCESS
	/// Hong 11/02/09 QA80-14562 EXP_MULTI_PAGE_PDF_SUPPORT_ORIENTATION_OPTION
	if ( trGetNPrintOpts.Orientation )
	{
		ASSERT( !(GPC_PAGE_ORIENTATION & dwSet) );
		dwSet |= (0 == trGetNPrintOpts.Orientation.nVal) ? GPC_PAGE_PORTRAIT : GPC_PAGE_LANDSCAPE;
	}
	/// end EXP_MULTI_PAGE_PDF_SUPPORT_ORIENTATION_OPTION
   	trWksPrintOpts.Root.Print.Cntrl.nVal = dwSet;
	
	TreeNode 	trMargin = trWksPrintOpts.Root.Print.Margin;
	///------ Folger 11/03/09 CLEAN_WKS_PRINT_OPTION_SETTINGS_ACCESS
	if ( trMargin && trMargin.Show )
	///------ End CLEAN_WKS_PRINT_OPTION_SETTINGS_ACCESS
	{
		double 		dFactor = trGetNPrintOpts.Margin.Use ? MARGIN_INCH_FACTOR : MARGIN_MM_FACTOR; //"mm | inch"
		trMargin.Left.dVal = trGetNPrintOpts.Margin.Left.dVal * dFactor;
		trMargin.Right.dVal = trGetNPrintOpts.Margin.Right.dVal * dFactor;
		trMargin.Top.dVal = trGetNPrintOpts.Margin.Top.dVal * dFactor;
		trMargin.Bottom.dVal = trGetNPrintOpts.Margin.Bottom.dVal * dFactor;
	}
}

bool apply_print_options(const TreeNode& trGetNPrintOpts, Worksheet& wks)
{
	Tree 		trPrintOptions;
	if ( !wks.GetPrintOptions(trPrintOptions) )
		return false;
	
	_cvt_getn_print_options_to_wks_print_options(trPrintOptions, trGetNPrintOpts);
	
	return wks.SetPrintOptions(trPrintOptions);
}
#endif		//SUPPORT_EXPORT_MULTI_PAGES_PDF
/// end EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS

// CPY 5/22/07
// dialog should be open only if hWndParent != NULL
// bInit = true is to reset options
BOOL wks_print_option(TreeNode &trSettings, HWND hWndParent)
{
	///Folger 04/12/07 QA70-9575 v8.0599 PRINT_OPTIONS_FOR_WKS_PRINT
	DWORD dwSet = trSettings.Root.Print.Cntrl.nVal;
	TreeNode trMargin = trSettings.Root.Print.Margin;
	
	GETN_TREE(tr)
	print_option_construct_tree(tr, dwSet, trMargin);
	
	if(hWndParent) // CPY 5/22/07 USING_SAME_FUNCTION_FOR_DLG_AND_INIT
   	{
   		if(!GetNBox(tr, _L("Option"), _L("Print Options"), NULL, NULL, hWndParent))
   			return false; // CPY 5/22/07 USING_SAME_FUNCTION_FOR_DLG_AND_INIT
   		/// Hong 06/17/09 QA80-13280 EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS
	#ifdef		SUPPORT_EXPORT_MULTI_PAGES_PDF
		_cvt_getn_print_options_to_wks_print_options(trSettings, tr);
	#else
		/// end EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS
		///------ Folger 11/03/09 CLEAN_WKS_PRINT_OPTION_SETTINGS_ACCESS
   		//dwSet = 0;
   		//dwSet |= (tr.Check.Chk_Horz_Grids.nVal ? GPC_HORZ_GRIDS : 0) |
   				 //(tr.Check.Chk_Vert_Grids.nVal ? GPC_VERT_GRIDS : 0) |
   				 //(tr.Check.Chk_Row_Header.nVal ? GPC_ROW_HEADER : 0) |
   				 //(tr.Check.Chk_Col_Header.nVal ? GPC_COL_HEADER : 0) |
   				 //(tr.Check.Chk_Page_Header.nVal ? GPC_PAGE_HEADER : 0) |
   				 //(tr.Check.Chk_Page_Footer.nVal ? GPC_PAGE_FOOTER : 0) |
   				 //(tr.Check.Chk_BkColor.nVal ? GPC_BACKGROUND : 0) |
				 //(tr.Check.Chk_Frame.nVal ? GPC_FRAME : 0) |
   				 //(tr.Check.Chk_EmptyCols.nVal ? GPC_EMPTY_COLS : 0) |
   				 //(tr.Check.Chk_EmptyRows.nVal ? GPC_EMPTY_ROWS : 0);
		O_SET_BIT(dwSet, GPC_HORZ_GRIDS, tr.Check.Chk_Horz_Grids.nVal);
		O_SET_BIT(dwSet, GPC_VERT_GRIDS, tr.Check.Chk_Vert_Grids.nVal);
		O_SET_BIT(dwSet, GPC_ROW_HEADER, tr.Check.Chk_Row_Header.nVal);
		O_SET_BIT(dwSet, GPC_COL_HEADER, tr.Check.Chk_Col_Header.nVal);
		O_SET_BIT(dwSet, GPC_PAGE_HEADER, tr.Check.Chk_Page_Header.nVal);
		O_SET_BIT(dwSet, GPC_PAGE_FOOTER, tr.Check.Chk_Page_Footer.nVal);
		O_SET_BIT(dwSet, GPC_BACKGROUND, tr.Check.Chk_BkColor.nVal);
		O_SET_BIT(dwSet, GPC_FRAME, tr.Check.Chk_Frame.nVal);
		O_SET_BIT(dwSet, GPC_EMPTY_COLS, tr.Check.Chk_EmptyCols.nVal);
		O_SET_BIT(dwSet, GPC_EMPTY_ROWS, tr.Check.Chk_EmptyRows.nVal);
		///------ End CLEAN_WKS_PRINT_OPTION_SETTINGS_ACCESS
   				 
		///------ Folger 11/03/09 CLEAN_WKS_PRINT_OPTION_SETTINGS_ACCESS
		if ( tr.Margin && tr.Margin.Show )
		///------ End CLEAN_WKS_PRINT_OPTION_SETTINGS_ACCESS
		{
			double dFactor = MARGIN_MM_FACTOR;
			if (tr.Margin.Use) //"mm | inch"
			{
				dFactor = MARGIN_INCH_FACTOR;
			}
			trMargin.Left.dVal = tr.Margin.Left.dVal * dFactor;
			trMargin.Right.dVal = tr.Margin.Right.dVal * dFactor;
			trMargin.Top.dVal = tr.Margin.Top.dVal * dFactor;
			trMargin.Bottom.dVal = tr.Margin.Bottom.dVal * dFactor;
		}
	#endif		//SUPPORT_EXPORT_MULTI_PAGES_PDF /// Hong 06/17/09 QA80-13280 EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS
   	}
#ifndef		SUPPORT_EXPORT_MULTI_PAGES_PDF /// Hong 06/17/09 QA80-13280 EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS
   	trSettings.Root.Print.Cntrl.nVal = dwSet;
#endif		//SUPPORT_EXPORT_MULTI_PAGES_PDF /// Hong 06/17/09 QA80-13280 EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS
   		
    // 	out_tree(tr);
	return TRUE;
	///End PRINT_OPTIONS_FOR_WKS_PRINT
}